/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xhost.h
 *       upload and download functions between 
 *       host/files and system/internal memory 
 * -----------------------------------------------------------------*/

#ifndef XHOST_H_INCLUDED
#define XHOST_H_INCLUDED

#include <xpropdef.h>
#include <xhostdef.h>

#define MASTER_BUFFER_DW_COUNT 127
#define INTERNAL_MEM_DW_SIZE   0x8000

/* verify flag for sysmemfill functions. Will be or'd to command */
CLI                /* DEF_START ~G_BX_HostAccess */
#define BX_HOST_VERIFY 0x100    /* @verify */
CLI                /* DEF_END */


#ifdef __cplusplus
extern "C" {
#endif

#ifndef SWIG 
CLI bx_errtype EXPORT BestXDataMemWrite(      /* @datamemwrite */
  bx_handletype handle,
  bx_int32    addr,    
  bx_int32    numbytes,    
  bx_int8     *data     
);

CLI bx_errtype EXPORT BestXDataMemRead(       /* @datamemread */
  bx_handletype handle,
  bx_int32     addr,      
  bx_int32     numbytes,   
  bx_int8      *data   /* @data #RETURN intelhexdump(data,numbytes,cmd,NULL,NULL) [numbytes] */
);

#else

/* chris: 
   Do not change the parameter names !
   SWIG relies on that 
*/
bx_errtype EXPORT BestXDataMemWrite( 
  bx_handletype handle,
  bx_int32    addr,    
  bx_int32    NumBytes4DataMemWrite,    
  bx_int8     *Data4DataMemWrite     
);

bx_errtype EXPORT BestXDataMemRead(
  bx_handletype handle,
  bx_int32     addr,      
  bx_int32     NumBytesFor8BitDataOut,   
  bx_int8      *DataFor8BitDataOut   
);
#endif

CLI bx_errtype EXPORT BestXDataMemWriteFile(  /* @datamemwritefile */
  bx_handletype handle,
  bx_int32 addr,                              /* $0 */
  bx_charptrtype file                         /* $"c:\\bx_datamem.bin" */
);

CLI bx_errtype EXPORT BestXDataMemReadFile(   /* @datamemreadfile */
  bx_handletype handle,
  bx_int32 addr,                              /* $0 */
  bx_int32 numbytes,
  bx_charptrtype file                         /* $"c:\\bx_datamem.bin" */
);

CLI bx_errtype EXPORT BestXDataMemInit(       /* @datameminit */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXDataMemPatternFill(  /* @datamempatternfill */
  bx_handletype handle,
  bx_int32     addr,         /* $0 */     
  bx_int32     numbytes,     
  bx_int32     val1,         /* $0 */
  bx_int32     val2,         /* $0 */
  bx_int32     val3,         /* $0 */
  bx_int32     val4,         /* $0 */
  bx_dmempatttype  pattern   /* @patt */
);  

CLI  bx_errtype EXPORT BestXHostPCIRegWrite(  /* @hpregwrite */
  bx_handletype    handle,
  bx_addrspacetype addrspace,      /* @space */
  bx_int32         bus_addr,       /* @bad */
  bx_int32         reg_value,      /* @val */
  bx_sizetype      wordsize        /* @size */
);
  
CLI  bx_errtype EXPORT BestXHostPCIRegRead(                       /* @hpregread */
  bx_handletype    handle,
  bx_addrspacetype addrspace,      /* @space */
  bx_int32         bus_addr,       /* @bad */
  bx_int32         *regvalue_ptr,  /* #RETURN "value =: %08lx\n" */
  bx_sizetype      wordsize        /* @size */
);

/*** for BX_PORT_PRODUCTION ***/
bx_errtype EXPORT BestXOpenProduction(bx_handletype handle);

bx_errtype EXPORT BestXDirectRegHostRead(
  bx_handletype handle,
  bx_int32 DeviceOnBackPlane,
  bx_int32 dir_addr,
  bx_int32 regsize,
  bx_int32 *reg_value
);

bx_errtype EXPORT BestXDirectRegHostWrite(
  bx_handletype handle,
  bx_int32 DeviceOnBackPlane,
  bx_int32 dir_addr,
  bx_int32 regsize,    
  bx_int32 reg_value
);


#ifdef __cplusplus
}
#endif

#endif





